Ext.data.JsonP.sol_common_jc_WebcamUtils({"tagname":"class","name":"sol.common.jc.WebcamUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"sol.common.jc.WebcamUtils.js","href":"sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils"}],"author":[{"tagname":"author","name":"JHR, ELO Digital Office GmbH","email":null}],"version":["1.0"],"elojc":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"dlgResult","tagname":"property","owner":"sol.common.jc.WebcamUtils","id":"property-dlgResult","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"userOptionSelectedIndex","tagname":"property","owner":"sol.common.jc.WebcamUtils","id":"property-userOptionSelectedIndex","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"adjustViewport","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-adjustViewport","meta":{"private":true}},{"name":"convertBase64StringToImage","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-convertBase64StringToImage","meta":{"private":true}},{"name":"convertImageToBase64String","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-convertImageToBase64String","meta":{"private":true}},{"name":"cropImage","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-cropImage","meta":{"private":true}},{"name":"getImage","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-getImage","meta":{}},{"name":"getText","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-getText","meta":{}},{"name":"getViewportRectangle","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-getViewportRectangle","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"saveImageAsJpg","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-saveImageAsJpg","meta":{"private":true}},{"name":"showBase64String","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-showBase64String","meta":{"private":true}},{"name":"showImage","tagname":"method","owner":"sol.common.jc.WebcamUtils","id":"method-showImage","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.jc.WebcamUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.jc.WebcamUtils</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils' target='_blank'>sol.common.jc.WebcamUtils.js</a></div></pre><div class='doc-contents'><p>This class provides functions to control webcams\ne.g for capturing pictures</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-dlgResult' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-property-dlgResult' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-property-dlgResult' class='name expandable'>dlgResult</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div><div id='property-userOptionSelectedIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-property-userOptionSelectedIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-property-userOptionSelectedIndex' class='name expandable'>userOptionSelectedIndex</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;ELOjc.WebcamUtils.selectedIndex&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-adjustViewport' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-adjustViewport' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-adjustViewport' class='name expandable'>adjustViewport</a>( <span class='pre'>scrollPane, webCamViewSize, cropImageDimension</span> ) : java.awt.Rectangle<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Adjust Viewport of scrollPane ...</div><div class='long'><p>Adjust Viewport of scrollPane</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>scrollPane</span> : javax.swing.JScrollPane<div class='sub-desc'>\n</div></li><li><span class='pre'>webCamViewSize</span> : java.awt.Dimension<div class='sub-desc'>\n</div></li><li><span class='pre'>cropImageDimension</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.awt.Rectangle</span><div class='sub-desc'><p>Viewport Rectangle</p>\n</div></li></ul></div></div></div><div id='method-convertBase64StringToImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-convertBase64StringToImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-convertBase64StringToImage' class='name expandable'>convertBase64StringToImage</a>( <span class='pre'>imageString</span> ) : java.awt.image.BufferedImage<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Convert image to base64 ...</div><div class='long'><p>Convert image to base64</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>imageString</span> : String<div class='sub-desc'><p>base64 String</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.awt.image.BufferedImage</span><div class='sub-desc'><p>image image</p>\n</div></li></ul></div></div></div><div id='method-convertImageToBase64String' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-convertImageToBase64String' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-convertImageToBase64String' class='name expandable'>convertImageToBase64String</a>( <span class='pre'>image, type</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Convert image to base64 ...</div><div class='long'><p>Convert image to base64</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>image</span> : java.awt.image.BufferedImage<div class='sub-desc'><p>image</p>\n</div></li><li><span class='pre'>type</span> : String<div class='sub-desc'><p>image type, e.g \"JPG\"</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>converted Base64 String</p>\n</div></li></ul></div></div></div><div id='method-cropImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-cropImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-cropImage' class='name expandable'>cropImage</a>( <span class='pre'>image, x, y, w, h</span> ) : java.awt.image.BufferedImage<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Get cropped image ...</div><div class='long'><p>Get cropped image</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>image</span> : java.awt.image.BufferedImage<div class='sub-desc'><p>image</p>\n</div></li><li><span class='pre'>x</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>y</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>w</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>h</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.awt.image.BufferedImage</span><div class='sub-desc'><p>cropped image</p>\n</div></li></ul></div></div></div><div id='method-getImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-getImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-getImage' class='name expandable'>getImage</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Shows a webcam and get captured image ...</div><div class='long'><p>Shows a webcam and get captured image</p>\n</div></div></div><div id='method-getText' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-getText' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-getText' class='name expandable'>getText</a>( <span class='pre'>key</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Helper function that returns localized text constants ...</div><div class='long'><p>Helper function that returns localized text constants</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Key of the text constants</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Localized text constant</p>\n</div></li></ul></div></div></div><div id='method-getViewportRectangle' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-getViewportRectangle' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-getViewportRectangle' class='name expandable'>getViewportRectangle</a>( <span class='pre'>w0, h0, w1, h1</span> ) : java.awt.Rectangle<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Get Viewport Rectangle ...</div><div class='long'><p>Get Viewport Rectangle</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>w0</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>h0</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>w1</span> : Number<div class='sub-desc'>\n</div></li><li><span class='pre'>h1</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.awt.Rectangle</span><div class='sub-desc'><p>Viewport Rectangle</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-saveImageAsJpg' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-saveImageAsJpg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-saveImageAsJpg' class='name expandable'>saveImageAsJpg</a>( <span class='pre'>image, path</span> ) : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Save image as jpg file ...</div><div class='long'><p>Save image as jpg file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>image</span> : java.awt.image.BufferedImage<div class='sub-desc'><p>image</p>\n</div></li><li><span class='pre'>path</span> : String<div class='sub-desc'><p>path</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-showBase64String' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-showBase64String' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-showBase64String' class='name expandable'>showBase64String</a>( <span class='pre'>base64</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>show base64 ...</div><div class='long'><p>show base64</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>base64</span> : String<div class='sub-desc'><p>base64</p>\n</div></li></ul></div></div></div><div id='method-showImage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.jc.WebcamUtils'>sol.common.jc.WebcamUtils</span><br/><a href='source/sol.common.jc.WebcamUtils.html#sol-common-jc-WebcamUtils-method-showImage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.jc.WebcamUtils-method-showImage' class='name expandable'>showImage</a>( <span class='pre'>image</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Show image ...</div><div class='long'><p>Show image</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>image</span> : java.awt.image.BufferedImage<div class='sub-desc'><p>image</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"elojc":true,"singleton":true}});